/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.SimpleData;
import cds.savot.model.FieldSet;
import cds.savot.model.GroupSet;
import cds.savot.model.ParamSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotGroup;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.pull.SavotPullParser;
import cds.tools.Util;
import java.net.URL;
import java.util.HashMap;
import java.util.List;

public class DatalinkServiceUtil {
    public static SavotPullParser getDataSets(URL accessUrl) {
        SavotPullParser savotParser = null;
        try {
            if (accessUrl != null) {
                savotParser = new SavotPullParser(accessUrl, 0, null, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return savotParser;
    }

    public static SavotGroup getInputParams(GroupSet groups) {
        SavotGroup group = null;
        if (groups != null && groups.getItemCount() > 0) {
            for (int i = 0; i < groups.getItemCount() && !(group = (SavotGroup)groups.getItemAt(i)).getName().equalsIgnoreCase("inputParams"); ++i) {
            }
        }
        return group;
    }

    public static SavotParam getInputParams(ParamSet params, String query) {
        SavotParam param = null;
        if (params != null && params.getItemCount() > 0) {
            for (int i = 0; i < params.getItemCount() && !(param = (SavotParam)params.getItemAt(i)).getName().equalsIgnoreCase(query); ++i) {
                param = null;
            }
        }
        return param;
    }

    public static void populateDataLinksInfo(URL datalinkUrl, List<SimpleData> datalinksInfo) {
        SavotResource resultsResource;
        if (datalinksInfo == null) {
            return;
        }
        SavotPullParser accessUrlResult = DatalinkServiceUtil.getDataSets(datalinkUrl);
        if (accessUrlResult != null && (resultsResource = Util.populateResultsResource(accessUrlResult)) != null) {
            SimpleData data = null;
            HashMap<String, String> params = null;
            for (int i = 0; i < resultsResource.getTableCount(); ++i) {
                TRSet tableRows = resultsResource.getTRSet(i);
                FieldSet fieldSet = resultsResource.getFieldSet(i);
                if (fieldSet == null || tableRows == null) continue;
                for (int j = 0; j < tableRows.getItemCount(); ++j) {
                    TDSet theTDs = tableRows.getTDSet(j);
                    data = new SimpleData();
                    params = new HashMap<String, String>();
                    String service_def = null;
                    for (int k = 0; k < theTDs.getItemCount(); ++k) {
                        SavotField field = (SavotField)resultsResource.getFieldSet(i).getItemAt(k);
                        String key = null;
                        String value = theTDs.getContent(k);
                        key = field.getId() == null || field.getId().isEmpty() ? field.getName() : field.getId();
                        if (key.equalsIgnoreCase("content_length") && value != null && !value.isEmpty()) {
                            try {
                                int length = Integer.parseInt(value);
                                if (length > 0) {
                                    String units = field.getUnit();
                                    if (units == null || units.isEmpty() || units.toLowerCase().startsWith("byte") || units.equals("B")) {
                                        int o;
                                        String mem = Util.getUnitDisk(length);
                                        for (o = mem.length() - 1; o >= 0 && !Character.isDigit(mem.charAt(o)); --o) {
                                        }
                                        if (o > 0) {
                                            value = mem.substring(0, o + 1);
                                            units = mem.substring(o + 1);
                                        }
                                    }
                                    value = value + units;
                                    params.put("content_length_display", value);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        params.put(key, value);
                        if (!field.getName().equalsIgnoreCase("service_def")) continue;
                        service_def = theTDs.getContent(k);
                    }
                    data.setParams(params);
                    if (service_def != null && !service_def.isEmpty()) {
                        data.setMetaResource(accessUrlResult.getResourceFromRef(service_def));
                        service_def = null;
                    }
                    datalinksInfo.add(data);
                }
            }
        }
    }

    public void addOriginalItems(List<SimpleData> possibleRepeats, List<SimpleData> newList) {
        boolean isSame = false;
        for (SimpleData possibleRepeat : possibleRepeats) {
            for (SimpleData simpleData : newList) {
                if (!possibleRepeat.isSameAs(simpleData)) continue;
                isSame = true;
            }
            if (isSame) continue;
            newList.add(possibleRepeat);
        }
    }
}

